#!/usr/bin/env node
import{parseArgs as e}from"node:util";import{exit as s}from"node:process";import{getCompatibleVersions as a}from"./index.js";const r=process.argv.slice(2),{values:n}=e({args:r,options:{"target-year":{type:"string"},"widely-available-on-date":{type:"string"},"include-downstream-browsers":{type:"boolean"},"list-all-compatible-versions":{type:"boolean"},"include-kaios":{type:"boolean"},"suppress-warnings":{type:"boolean"},"override-last-updated":{type:"string"},help:{type:"boolean",short:"h"}},strict:!0});n.help&&(console.log("\nGet Baseline Widely available browser versions or Baseline year browser versions.\n\nUsage: baseline-browser-mapping [options]\n\nOptions:\n      --target-year                   Pass a year between 2015 and the current year to get browser versions compatible \n                                      with all Newly Available features as of the end of the year specified.\n      --widely-available-on-date      Pass a date in the format 'YYYY-MM-DD' to get versions compatible with Widely \n                                      available on the specified date.\n      --include-downstream-browsers   Whether to include browsers that use the same engines as a core Baseline browser.\n      --include-kaios                 Whether to include KaiOS in downstream browsers.  Requires --include-downstream-browsers.\n      --list-all-compatible-versions  Whether to include only the minimum compatible browser versions or all compatible versions.\n      --suppress-warnings             Supress potential warnings about data staleness when using a very recent feature cut off date.\n      --override-last-updated         Override the last updated date for the baseline data for debugging purposes.\n  -h, --help                          Show help\n\nExamples:\n  npx baseline-browser-mapping --target-year 2020\n  npx baseline-browser-mapping --widely-available-on-date 2023-04-05\n  npx baseline-browser-mapping --include-downstream-browsers\n  npx baseline-browser-mapping --list-all-compatible-versions\n".trim()),s(0)),console.log(a({targetYear:n["target-year"]?Number.parseInt(n["target-year"]):void 0,widelyAvailableOnDate:n["widely-available-on-date"],includeDownstreamBrowsers:n["include-downstream-browsers"],listAllCompatibleVersions:n["list-all-compatible-versions"],includeKaiOS:n["include-kaios"],suppressWarnings:n["suppress-warnings"],overrideLastUpdated:n["override-last-updated"]?Number.parseInt(n["override-last-updated"]):void 0}));
